<!DOCTYPE html>
<html>
<head>
    <title><?php _e('Your Data Subject Request Confirmation', 'dsr-form'); ?></title>
    <style>
        body { font-family: Arial, sans-serif; background: #f6f8fa; color: #222; }
        .container { max-width: 600px; margin: 30px auto; background: #fff; border-radius: 8px; box-shadow: 0 2px 8px #e0e0e0; padding: 32px; }
        .header { background: #0073aa; color: #fff; padding: 18px 0; border-radius: 8px 8px 0 0; text-align: center; }
        .content { padding: 24px 0; }
        .footer { font-size: 13px; color: #888; text-align: center; margin-top: 24px; }
        .info-table { width: 100%; border-collapse: collapse; margin-top: 16px; }
        .info-table th, .info-table td { text-align: left; padding: 8px 10px; }
        .info-table th { background: #f0f4f8; }
        .info-table tr:nth-child(even) { background: #f9f9f9; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2><?php _e('Your Data Subject Request Has Been Received', 'dsr-form'); ?></h2>
        </div>
        <div class="content">
            <p><?php _e('Dear', 'dsr-form'); ?> <?php echo esc_html($request['request_data']['first_name']); ?>,</p>
            <p><?php _e('Thank you for submitting your data subject request. We have received your request and assigned it the following tracking ID for your reference:', 'dsr-form'); ?></p>
            <p style="font-size:18px; font-weight:bold; color:#0073aa;">#<?php echo esc_html($request['tracking_id']); ?></p>
            <p><?php _e('Below is a summary of your request:', 'dsr-form'); ?></p>
            <table class="info-table">
                <tr><th><?php _e('First Name', 'dsr-form'); ?></th><td><?php echo esc_html($request['request_data']['first_name']); ?></td></tr>
                <tr><th><?php _e('Last Name', 'dsr-form'); ?></th><td><?php echo esc_html($request['request_data']['last_name']); ?></td></tr>
                <tr><th><?php _e('Email', 'dsr-form'); ?></th><td><?php echo esc_html($request['request_data']['email']); ?></td></tr>
                <tr><th><?php _e('Country', 'dsr-form'); ?></th><td><?php echo esc_html($request['request_data']['country']); ?></td></tr>
                <tr><th><?php _e('Region', 'dsr-form'); ?></th><td><?php echo esc_html($request['request_data']['user_type']); ?></td></tr>
                <tr><th><?php _e('I am a (an)', 'dsr-form'); ?></th><td><?php echo esc_html($request['request_data']['user_identity']); ?></td></tr>
                <tr><th><?php _e('Request Type(s)', 'dsr-form'); ?></th><td><?php echo isset($request['request_data']['request_types']) ? esc_html(implode(', ', $request['request_data']['request_types'])) : '-'; ?></td></tr>
                <tr><th><?php _e('Request Details', 'dsr-form'); ?></th><td><?php echo esc_html($request['request_data']['details']); ?></td></tr>
                <tr><th><?php _e('Attachment', 'dsr-form'); ?></th><td><?php echo !empty($request['request_data']['attachment']) ? '<a href="' . esc_url($request['request_data']['attachment']) . '" target="_blank">View File</a>' : '-'; ?></td></tr>
                <tr><th><?php _e('Date Submitted', 'dsr-form'); ?></th><td><?php echo date_i18n(get_option('date_format'), strtotime($request['created_at'])); ?></td></tr>
            </table>
            <p style="margin-top:24px; color:#444; font-size:15px;">
                <?php _e('We will process your request in accordance with applicable data protection laws. If you have any questions or need to provide additional information, please reply to this email or contact our Data Protection Officer.', 'dsr-form'); ?>
            </p>
        </div>
        <div class="footer">
            <?php _e('This is an automated confirmation from your website DSR system. Please keep this email for your records.', 'dsr-form'); ?>
        </div>
    </div>
</body>
</html>