<?php
$license_status = get_option('xpertlync_dsr_license_status');
$license_key = get_option('xpertlync_dsr_license_key');
$license_active = ($license_status === 'active' && !empty($license_key));
$razorpay_payment_url = 'https://rzp.io/l/your-license-payment-link'; // Replace with your Razorpay payment link
$return_url = admin_url('admin.php?page=xpertlync-dsr-form&license_payment=success');
?>
<div class="dsr-admin-modern">
    <h1 class="dsr-admin-title"><?php _e('DSR Form Settings', 'dsr-form'); ?></h1>
    <div class="dsr-admin-sections">
        <form method="post" action="options.php" class="dsr-admin-card">
            <?php settings_fields('dsr_settings'); ?>
            <h2 class="dsr-admin-heading">1. <?php _e('Email Settings', 'dsr-form'); ?></h2>
            <?php do_settings_sections('dsr-settings'); ?>
            <div class="dsr-admin-btn-row">
                <?php if ($license_active): ?>
                    <?php submit_button(__('Save Settings', 'dsr-form'), 'primary', '', false, array('class' => 'dsr-admin-btn dsr-admin-btn-primary')); ?>
                <?php else: ?>
                    <button type="submit" class="dsr-admin-btn dsr-admin-btn-disabled" disabled>Save Settings</button>
                <?php endif; ?>
            </div>
        </form>
        <div class="dsr-admin-card">
            <h2 class="dsr-admin-heading">2. <?php _e('Shortcode', 'dsr-form'); ?></h2>
            <p><?php _e('Place this shortcode on any page or post to display the DSR Request Form:', 'dsr-form'); ?></p>
            <input type="text" readonly value="[dsr_form]" class="dsr-admin-shortcode" onclick="this.select();">
        </div>
        <div class="dsr-admin-card">
            <h2 class="dsr-admin-heading">3. <?php _e('Custom Notification Preview', 'dsr-form'); ?></h2>
            <div class="dsr-admin-preview">
                <?php echo nl2br(esc_html(get_option('dsr_custom_notification', 'Default notification template...'))); ?>
            </div>
        </div>
    </div>
</div>
<style>
.dsr-admin-modern {
    font-family: 'Segoe UI', Arial, sans-serif;
    background: #f4f6fa;
    padding: 32px 0;
}
.dsr-admin-title {
    font-size: 2.2rem;
    margin-bottom: 32px;
    color: #1a202c;
    text-align: center;
}
.dsr-admin-sections {
    display: flex;
    flex-wrap: wrap;
    gap: 32px;
    justify-content: center;
}
.dsr-admin-card {
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 2px 12px rgba(0,0,0,0.07);
    padding: 32px 28px 24px 28px;
    min-width: 340px;
    max-width: 520px;
    flex: 1 1 340px;
    margin-bottom: 0;
}
.dsr-admin-heading {
    font-size: 1.3rem;
    color: #0d6efd;
    margin-bottom: 18px;
    border-bottom: 1px solid #e3e8ee;
    padding-bottom: 6px;
}
.dsr-admin-alert-error {
    background: #fff1f0;
    border: 1px solid #ffa39e;
    color: #cf1322;
    padding: 18px 20px;
    border-radius: 8px;
    margin-bottom: 18px;
}
.dsr-admin-alert-success {
    background: #f6ffed;
    border: 1px solid #b7eb8f;
    color: #389e0d;
    padding: 18px 20px;
    border-radius: 8px;
    margin-bottom: 18px;
}
.dsr-admin-btn-row {
    display: flex;
    justify-content: flex-end;
    margin-top: 18px;
}
.dsr-admin-btn {
    font-size: 1rem;
    padding: 10px 28px;
    border-radius: 6px;
    border: none;
    background: #0d6efd;
    color: #fff;
    cursor: pointer;
    transition: background 0.2s, box-shadow 0.2s;
    box-shadow: 0 2px 6px rgba(13,110,253,0.08);
    margin-left: 8px;
}
.dsr-admin-btn-primary {
    background: #0d6efd;
}
.dsr-admin-btn-primary:hover {
    background: #0b5ed7;
}
.dsr-admin-btn-disabled {
    background: #e3e8ee;
    color: #b0b8c1;
    cursor: not-allowed;
}
.dsr-admin-shortcode {
    width: 320px;
    font-size: 1.1rem;
    padding: 8px 12px;
    border-radius: 6px;
    border: 1px solid #e3e8ee;
    background: #f8fafc;
    margin-top: 8px;
    margin-bottom: 8px;
}
.dsr-admin-preview {
    background: #f8fafc;
    border: 1px solid #e3e8ee;
    border-radius: 6px;
    padding: 18px;
    font-size: 1rem;
    color: #333;
    margin-bottom: 0;
}
@media (max-width: 900px) {
    .dsr-admin-sections {
        flex-direction: column;
        gap: 24px;
        align-items: center;
    }
    .dsr-admin-card {
        min-width: 90vw;
        max-width: 98vw;
    }
}
</style>
<script>
jQuery(document).ready(function($){
    if ($('#dsr-test-email-btn').length && !$('#dsr-test-email-status').length) {
        $('<span id="dsr-test-email-status" style="margin-left:12px;font-size:15px;"></span>').insertAfter('#dsr-test-email-btn');
    }
});
</script>
