<?php
class DSR_Email_Handler {
    public function send_confirmation($tracking_id) {
        $request = $this->get_request($tracking_id);
        $to = $request['request_data']['email'];
        $subject = __('Your Data Subject Request Received', 'dsr-form');
        $custom_template = get_option('dsr_custom_notification', '');
        if (!empty($custom_template)) {
            $message = $this->replace_placeholders($custom_template, $request);
        } else {
            $message = $this->generate_email_template($request, 'confirmation');
        }
        $headers = array('Content-Type: text/html; charset=UTF-8');
        wp_mail($to, $subject, nl2br($message), $headers);
    }
    
    public function send_dpo_notification($tracking_id) {
        $request = $this->get_request($tracking_id);
        $to = get_option('dsr_dpo_email', get_option('admin_email'));
        $subject = __('New Data Subject Request Received', 'dsr-form');
        $message = $this->generate_email_template($request, 'notification');
        $headers = array('Content-Type: text/html; charset=UTF-8');
        $attachments = array();
        // Attach file if present
        if (!empty($request['request_data']['attachment_path'])) {
            $attachment_path = $request['request_data']['attachment_path'];
            if (defined('WP_DEBUG') && WP_DEBUG) {
                error_log('[DSR] Attempting to attach file: ' . $attachment_path);
                error_log('[DSR] File exists: ' . (file_exists($attachment_path) ? 'yes' : 'no'));
            }
            if (file_exists($attachment_path)) {
                $attachments[] = $attachment_path;
            }
        } else if (!empty($request['request_data']['attachment'])) {
            // fallback for legacy data
            $attachment_url = $request['request_data']['attachment'];
            $attachment_id = attachment_url_to_postid($attachment_url);
            $file_path = '';
            if ($attachment_id) {
                $file_path = get_attached_file($attachment_id);
            }
            // Fallback: try to resolve file path from URL if attachment_id is not found
            if (!$file_path && strpos($attachment_url, get_site_url()) === 0) {
                $upload_dir = wp_upload_dir();
                $file_path = str_replace($upload_dir['baseurl'], $upload_dir['basedir'], $attachment_url);
            }
            if (defined('WP_DEBUG') && WP_DEBUG) {
                error_log('[DSR] Fallback attachment URL: ' . $attachment_url);
                error_log('[DSR] Fallback resolved file path: ' . $file_path);
                error_log('[DSR] Fallback file exists: ' . ($file_path && file_exists($file_path) ? 'yes' : 'no'));
            }
            if ($file_path && file_exists($file_path)) {
                $attachments[] = $file_path;
            } else {
                if (defined('WP_DEBUG') && WP_DEBUG) {
                    error_log('[DSR] Attachment not found or not accessible: ' . $attachment_url . ' | Resolved path: ' . $file_path);
                }
            }
        }
        wp_mail($to, $subject, $message, $headers, $attachments);
    }
    
    private function get_request($tracking_id) {
        $db_handler = new DSR_DB_Handler();
        return $db_handler->get_request($tracking_id);
    }
    
    private function generate_email_template($request, $type) {
        ob_start();
        include DSR_PLUGIN_DIR . "templates/emails/$type-email.php";
        return ob_get_clean();
    }
    
    private function replace_placeholders($template, $request) {
        $data = $request['request_data'];
        // Support both request_type (single) and request_types (array)
        $request_types = '';
        if (isset($data['request_types'])) {
            $request_types = is_array($data['request_types']) ? implode(', ', $data['request_types']) : $data['request_types'];
        } elseif (isset($data['request_type'])) {
            $request_types = $data['request_type'];
        }
        $replace = array(
            '{first_name}'   => isset($data['first_name']) ? $data['first_name'] : '',
            '{last_name}'    => isset($data['last_name']) ? $data['last_name'] : '',
            '{email}'        => isset($data['email']) ? $data['email'] : '',
            '{country}'      => isset($data['country']) ? $data['country'] : '',
            '{user_type}'    => isset($data['user_type']) ? $data['user_type'] : '',
            '{user_identity}' => isset($data['user_identity']) ? $data['user_identity'] : '',
            '{request_types}' => $request_types,
            '{request_type}'  => $request_types, // Support {request_type} as alias for {request_types}
            '{details}'      => isset($data['details']) ? $data['details'] : '',
            '{attachment}'   => !empty($data['attachment']) ? $data['attachment'] : '',
            '{tracking_id}'  => isset($request['tracking_id']) ? $request['tracking_id'] : '',
            '{site_name}'    => get_bloginfo('name'),
        );
        return strtr($template, $replace);
    }
}