<?php
class DSR_Admin_Settings {
    public function __construct() {
        add_action('admin_menu', array($this, 'add_admin_menu'));
        add_action('admin_init', array($this, 'register_settings'));
        add_action('admin_enqueue_scripts', array($this, 'enqueue_admin_assets'));
        add_action('wp_ajax_dsr_send_test_email', array($this, 'send_test_email'));
    }
    
    public function add_admin_menu() {
        add_menu_page(
            __('XpertLync DSR Form', 'dsr-form'), // Main menu title
            __('XpertLync DSR Form', 'dsr-form'), // Menu label
            'manage_options',
            'xpertlync-dsr-form',
            array($this, 'render_settings_page'),
            'dashicons-privacy'
        );
        add_submenu_page(
            'xpertlync-dsr-form',
            __("XpertLync's DSR Form", 'dsr-form'),
            __("XpertLync's DSR Form", 'dsr-form'),
            'manage_options',
            'xpertlync-dsr-form',
            array($this, 'render_settings_page')
        );
        add_submenu_page(
            'xpertlync-dsr-form',
            __('Compliant List', 'dsr-form'),
            __('Compliant List', 'dsr-form'),
            'manage_options',
            'dsr-requests',
            array($this, 'render_requests_page')
        );
        // Removed the DSR Form Settings menu
    }
    
    public function register_settings() {
        // Register all settings under a single group for proper saving
        register_setting('dsr_settings', 'dsr_dpo_email');
        register_setting('dsr_settings', 'dsr_email_subject');
        register_setting('dsr_settings', 'dsr_email_template');
        register_setting('dsr_settings', 'dsr_test_email_status');
        register_setting('dsr_settings', 'dsr_custom_notification');
        register_setting('dsr_settings', 'dsr_captcha_type');
        register_setting('dsr_settings', 'dsr_recaptcha_site_key');
        register_setting('dsr_settings', 'dsr_recaptcha_secret_key');

        add_settings_section(
            'dsr_email_section',
            __('Email Settings', 'dsr-form'),
            array($this, 'render_email_section'),
            'dsr-settings'
        );
        add_settings_field(
            'dsr_dpo_email',
            __('DPO Email Address', 'dsr-form'),
            array($this, 'render_dpo_email_field'),
            'dsr-settings',
            'dsr_email_section'
        );
        add_settings_field(
            'dsr_email_subject',
            __('Email Subject', 'dsr-form'),
            array($this, 'render_email_subject_field'),
            'dsr-settings',
            'dsr_email_section'
        );
        add_settings_field(
            'dsr_test_email_status',
            __('Test Email', 'dsr-form'),
            array($this, 'render_test_email_field'),
            'dsr-settings',
            'dsr_email_section'
        );
        add_settings_field(
            'dsr_custom_notification',
            __('Custom Notification Template', 'dsr-form'),
            array($this, 'render_custom_notification_field'),
            'dsr-settings',
            'dsr_email_section'
        );
        add_settings_section(
            'dsr_captcha_section',
            __('Captcha Settings', 'dsr-form'),
            array($this, 'render_captcha_section'),
            'dsr-settings'
        );
        add_settings_field(
            'dsr_captcha_type',
            __('Captcha Type', 'dsr-form'),
            array($this, 'render_captcha_type_field'),
            'dsr-settings',
            'dsr_captcha_section'
        );
        add_settings_field(
            'dsr_recaptcha_site_key',
            __('reCAPTCHA Site Key', 'dsr-form'),
            array($this, 'render_recaptcha_site_key_field'),
            'dsr-settings',
            'dsr_captcha_section'
        );
        add_settings_field(
            'dsr_recaptcha_secret_key',
            __('reCAPTCHA Secret Key', 'dsr-form'),
            array($this, 'render_recaptcha_secret_key_field'),
            'dsr-settings',
            'dsr_captcha_section'
        );
    }

    public function render_email_section() {
        echo '<p>' . __('Configure email and notification settings for DSR requests.', 'dsr-form') . '</p>';
    }
    public function render_dpo_email_field() {
        $license_status = get_option('xpertlync_dsr_license_status');
        $license_key = get_option('xpertlync_dsr_license_key');
        $license_active = ($license_status === 'active' && !empty($license_key));
        $value = esc_attr(get_option('dsr_dpo_email', ''));
        $disabled = $license_active ? '' : 'disabled readonly style="background-color: #e9ecef;"';
        echo "<input type='email' name='dsr_dpo_email' value='$value' class='regular-text' $disabled />";
    }
    public function render_email_subject_field() {
        $saved = get_option('dsr_email_subject', '');
        $old_default = 'Test Message from Plugin';
        $new_default = 'Attn: Action requested by Data Subject {first_name} {last_name}.';
        if ($saved === '' || $saved === $old_default) {
            $value = $new_default;
        } else {
            $value = $saved;
        }
        $value = esc_attr($value);
        echo "<input type='text' name='dsr_email_subject' value='$value' class='regular-text' />";
    }
    public function render_test_email_field() {
        echo '<button type="button" class="button" id="dsr-test-email-btn">' . __('Send Test Email', 'dsr-form') . '</button>';
        echo '<button type="button" class="button" id="dsr-test-email-debug-btn" style="margin-left:8px;background:#6c757d;color:#fff;">Debug</button>';
        echo '<span id="dsr-test-email-status" style="margin-left:12px;font-size:15px;"></span>';
    }
    public function render_custom_notification_field() {
        $default = "Dear {first_name} {last_name},\n\nThank you for submitting your data subject request to {site_name}.\n\nYour request has been received and assigned the following tracking ID: {tracking_id}\n\nRequest Summary:\n- Request Type: {request_type}\n- Details: {details}\n\nWe will process your request in accordance with applicable data protection laws. If you have any questions, please reply to this email.\n\nBest regards,\nCompliance Team\n{site_name}";
        $value = get_option('dsr_custom_notification', null);
        if ($value === false || $value === null || trim($value) === '' || $value === 'Default notification template...') {
            $value = $default;
            update_option('dsr_custom_notification', $default);
        }
        echo "<textarea name='dsr_custom_notification' rows='8' class='large-text'>" . esc_textarea($value) . "</textarea>";
        echo '<p class="description">' . __('You can use placeholders like {first_name}, {last_name}, {email}, {tracking_id}, {request_type}, {details}, {site_name}.', 'dsr-form') . '</p>';
    }
    public function render_captcha_section() {
        echo '<p>' . __('Configure the captcha for the DSR request form. Choose between built-in captcha or Google reCAPTCHA.', 'dsr-form') . '</p>';
    }
    public function render_captcha_type_field() {
        $value = esc_attr(get_option('dsr_captcha_type', 'simple'));
        echo '<select name="dsr_captcha_type">
            <option value="simple"' . selected($value, 'simple', false) . '>' . __('Simple Captcha', 'dsr-form') . '</option>
            <option value="recaptcha"' . selected($value, 'recaptcha', false) . '>' . __('Google reCAPTCHA', 'dsr-form') . '</option>
        </select>';
    }
    public function render_recaptcha_site_key_field() {
        $license_status = get_option('xpertlync_dsr_license_status');
        $license_key = get_option('xpertlync_dsr_license_key');
        $license_active = ($license_status === 'active' && !empty($license_key));
        $value = esc_attr(get_option('dsr_recaptcha_site_key', ''));
        $disabled = $license_active ? '' : 'disabled readonly style="background-color: #e9ecef;"';
        echo "<input type='text' name='dsr_recaptcha_site_key' value='$value' class='regular-text' autocomplete='off' placeholder='Enter or update reCAPTCHA Site Key' $disabled />";
    }
    public function render_recaptcha_secret_key_field() {
        $license_status = get_option('xpertlync_dsr_license_status');
        $license_key = get_option('xpertlync_dsr_license_key');
        $license_active = ($license_status === 'active' && !empty($license_key));
        $value = esc_attr(get_option('dsr_recaptcha_secret_key', ''));
        $disabled = $license_active ? '' : 'disabled readonly style="background-color: #e9ecef;"';
        echo "<input type='text' name='dsr_recaptcha_secret_key' value='$value' class='regular-text' autocomplete='off' placeholder='Enter or update reCAPTCHA Secret Key' $disabled />";
    }
    
    public function render_settings_page() {
        include DSR_PLUGIN_DIR . 'templates/admin/settings-page.php';
        echo '<script>if (!document.getElementById("dsr-test-email-status")) { var btn = document.getElementById("dsr-test-email-btn"); if(btn){ var span = document.createElement("span"); span.id = "dsr-test-email-status"; span.style.marginLeft = "12px"; span.style.fontSize = "15px"; btn.parentNode.insertBefore(span, btn.nextSibling); } }</script>';
    }
    
    public function render_requests_page() {
        include DSR_PLUGIN_DIR . 'templates/admin/requests-page.php';
    }
    
    public function send_test_email() {
        $to = get_option('dsr_dpo_email');
        $subject = __('Test DSR Email', 'dsr-form');
        $message = __('This is a test email from the DSR plugin settings.', 'dsr-form');
        $debug = [
            'to' => $to,
            'subject' => $subject,
            'message' => $message,
            'mail_function_exists' => function_exists('wp_mail'),
        ];
        $result = wp_mail($to, $subject, $message);
        $debug['wp_mail_result'] = $result;
        if ($result) {
            wp_send_json_success(['debug' => $debug]);
        } else {
            wp_send_json_error('Could not send email. Check your email settings.', 0, ['debug' => $debug]);
        }
    }
    
    public function enqueue_admin_assets() {
        // Enqueue admin-specific styles and scripts
        $plugin_root = dirname(__DIR__) . '/dsr-request-form.php';
        wp_enqueue_style('dsr-admin-style', plugins_url('assets/css/admin-style.css', $plugin_root));
        wp_enqueue_script('dsr-admin-script', plugins_url('assets/js/admin-script.js', $plugin_root), array('jquery'), null, true);
    }
    
    public function enforce_license_check() {
        $license_active = get_option('xpertlync_dsr_license_status') === 'active';
        if (!$license_active) {
            add_action('admin_notices', function() {
                echo '<div class="notice notice-error"><p>' . __('License is inactive. Please activate your license to enable settings.', 'dsr-form') . '</p></div>';
            });
        }
    }
    
    // The DSR Form Settings menu is removed
}

// Remove the DSR Form Settings menu
add_action('admin_menu', function() {
    global $submenu;
    if (isset($submenu['xpertlync-dsr-form'])) {
        foreach ($submenu['xpertlync-dsr-form'] as $key => $menu_item) {
            if ($menu_item[2] === 'dsr-form-settings') {
                unset($submenu['xpertlync-dsr-form'][$key]);
            }
        }
    }
}, 999);

// Ensure admin settings fields are non-editable and greyed out if the license is not activated
function dsr_form_settings_page() {
    $license_status = get_option('xpertlync_dsr_license_status', 'inactive');

    echo '<div class="wrap">';
    echo '<h1>' . __('DSR Form Settings', 'dsr-form') . '</h1>';

    $disabled = ($license_status !== 'active') ? 'disabled readonly style="background-color: #e9ecef;"' : '';

    if ($license_status !== 'active') {
        echo '<div class="notice notice-error"><p>' . __('You must activate a valid license to edit these settings.', 'dsr-form') . '</p></div>';
    }

    // Example settings form
    echo '<form method="post">';
    echo '<label for="example_setting">' . __('Example Setting:', 'dsr-form') . '</label><br>';
    echo '<input type="text" id="example_setting" name="example_setting" ' . $disabled . '><br><br>';
    echo '<input type="submit" value="Save Settings" class="button button-primary" ' . $disabled . '>'; // Ensure submit button is also disabled
    echo '</form>';
    echo '</div>';
}

function dsr_register_admin_menu_settings() {
    add_submenu_page(
        'xpertlync-dsr-form',
        __('DSR Form Settings', 'dsr-form'),
        __('DSR Form Settings', 'dsr-form'),
        'manage_options',
        'dsr-form-settings',
        'dsr_form_settings_page'
    );
}
add_action('admin_menu', 'dsr_register_admin_menu_settings');

// Force removal of DSR Form Settings menu
add_action('admin_menu', function() {
    remove_menu_page('dsr-form-settings');
}, 999);