<?php
/**
 * Plugin Name: Data Subject Request Form
 * Description: Handle GDPR/CCPA data subject requests through a frontend form.
 * Version: 1.0.0
 * Author: XpertLync Solutions Pvt. Ltd.
 * License: GPL-2.0+
 */

defined('ABSPATH') or die('Direct access not allowed');

// Define plugin constants
define('DSR_VERSION', '1.0.0');
define('DSR_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('DSR_PLUGIN_URL', plugin_dir_url(__FILE__));

// Include required files
require_once DSR_PLUGIN_DIR . 'includes/class-db-handler.php';
require_once DSR_PLUGIN_DIR . 'includes/class-form-handler.php';
require_once DSR_PLUGIN_DIR . 'includes/class-email-handler.php';
require_once DSR_PLUGIN_DIR . 'includes/class-shortcode.php';
require_once DSR_PLUGIN_DIR . 'includes/class-admin-settings.php';
require_once DSR_PLUGIN_DIR . 'includes/class-license-handler.php';

// Register license lifecycle hooks in the main plugin file
register_activation_hook(__FILE__, array('DSR_License_Lifecycle', 'activate'));
register_deactivation_hook(__FILE__, array('DSR_License_Lifecycle', 'deactivate'));
register_uninstall_hook(__FILE__, array('DSR_License_Lifecycle', 'uninstall'));

// Initialize plugin
class DSR_Request_Form {
    public function __construct() {
        register_activation_hook(__FILE__, array($this, 'activate'));
        register_deactivation_hook(__FILE__, array($this, 'deactivate'));
        
        $this->init_components();
    }
    
    public function activate() {
        DSR_DB_Handler::create_tables();
        flush_rewrite_rules();
    }
    
    public function deactivate() {
        flush_rewrite_rules();
    }
    
    private function init_components() {
        new DSR_DB_Handler();
        new DSR_Form_Handler();
        new DSR_Email_Handler();
        new DSR_Shortcode();
        new DSR_Admin_Settings();
        new DSR_License_Handler(); // Instantiate the DSR_License_Handler class
    }
}

new DSR_Request_Form();