jQuery(document).ready(function($) {
    // Tab switching
    $('.dsr-tab').on('click', function(e) {
        e.preventDefault();
        const tabId = $(this).data('tab');
        
        // Update active tab
        $('.dsr-tab').removeClass('active');
        $(this).addClass('active');
        
        // Update active content
        $('.dsr-tab-content').removeClass('active');
        $(`#${tabId}-tab-content`).addClass('active');
        
        // Update hidden user_type field
        $('#dsr-user-type').val(tabId);
    });
    
    // Form submission
    $('#dsr-request-form').on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const submitButton = form.find('.dsr-submit-button');
        const responseMessage = $('#dsr-response-message');

        // Remove 'required' from hidden checkboxes (fix for not focusable error)
        $('.dsr-btn-group input[type="checkbox"][required][style*="display:none"]').removeAttr('required');

        // Custom validation: require at least one request_types[] checked and all required fields
        var missing = false;
        // Check all visible required fields
        form.find(':input[required]:visible').each(function() {
            if (!$(this).val()) {
                missing = true;
            }
        });
        // Check at least one request_types[]
        var checked = form.find('input[name="request_types[]"]:checked').length;
        if (checked === 0) {
            missing = true;
        }
        // File extension validation
        var fileInput = form.find('input[type="file"]');
        if (fileInput.length && fileInput[0].files.length > 0) {
            var file = fileInput[0].files[0];
            var ext = file.name.split('.').pop().toLowerCase();
            if (['pdf', 'docx'].indexOf(ext) === -1) {
                e.preventDefault();
                alert('Only .docx and .pdf files are allowed.');
                return false;
            }
        }
        if (missing) {
            e.preventDefault();
            alert('Please fill the mandatory fields marked with (*) in the form.');
            return false;
        }

        submitButton.prop('disabled', true).text('Submitting...');
        responseMessage.removeClass('success error').hide();

        // --- reCAPTCHA fix: append g-recaptcha-response if present ---
        var formData = form.serializeArray();
        var recaptchaResponse = typeof grecaptcha !== 'undefined' ? grecaptcha.getResponse() : '';
        if ($('.g-recaptcha').length && recaptchaResponse) {
            formData.push({ name: 'g-recaptcha-response', value: recaptchaResponse });
        }
        // ------------------------------------------------------------

        $.ajax({
            url: dsr_ajax.ajax_url,
            type: 'POST',
            data: $.param(formData),
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    responseMessage.addClass('success').html(`
                        <p>${response.data.message}</p>
                        <p>${dsr_ajax.tracking_text}: <strong>${response.data.tracking_id}</strong></p>
                    `).show();
                    form[0].reset();
                    if (typeof grecaptcha !== 'undefined') grecaptcha.reset();
                } else {
                    responseMessage.addClass('error').text(response.data).show();
                    if (typeof grecaptcha !== 'undefined') grecaptcha.reset();
                }
            },
            error: function(xhr, status, error) {
                responseMessage.addClass('error').text('An error occurred. Please try again.').show();
            },
            complete: function() {
                submitButton.prop('disabled', false).text(dsr_ajax.submit_text);
                $('html, body').animate({
                    scrollTop: responseMessage.offset().top - 100
                }, 500);
            }
        });
    });
    
    // Region selection logic
    $('#dsr-user-type').on('change', function() {
        var region = $(this).val();
        // AJAX to load region-specific fields
        $.ajax({
            url: dsr_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'dsr_load_region_fields',
                region: region,
                security: dsr_ajax.nonce
            },
            success: function(response) {
                if (response.success) {
                    $('#dsr-region-fields').html(response.data.html);
                }
            }
        });
    });
    
    // Tracking ID status check
    $('#dsr-check-tracking-btn').on('click', function() {
        var trackingId = $('#dsr-tracking-id-check').val().trim();
        var resultDiv = $('#dsr-tracking-status-result');
        if (!trackingId.match(/^\d{6}$/)) {
            resultDiv.html('<span style="color:red;">Please enter a valid 6-digit Tracking ID.</span>');
            return;
        }
        resultDiv.html('Checking...');
        $.post(dsr_ajax.ajax_url, {
            action: 'dsr_check_tracking_status',
            tracking_id: trackingId
        }, function(response) {
            if (response.success && response.data) {
                var nameLine = response.data.name ? '<strong>Filed By:</strong> ' + response.data.name + '<br>' : '';
                resultDiv.html(nameLine + '<strong>Status:</strong> ' + response.data.status + '<br><strong>Date Filed:</strong> ' + response.data.filed_date);
            } else {
                resultDiv.html('<span style="color:red;">Tracking ID not found.</span>');
            }
        });
    });
});