// Ensure ajaxurl is defined for AJAX requests
if (typeof ajaxurl === 'undefined') {
    window.ajaxurl = window.ajaxurl || '/wp-admin/admin-ajax.php';
}

jQuery(document).ready(function($){
    // Always ensure the status span exists
    if ($('#dsr-test-email-btn').length && !$('#dsr-test-email-status').length) {
        $('<span id="dsr-test-email-status" style="margin-left:12px;font-size:15px;"></span>').insertAfter('#dsr-test-email-btn');
    }
    var dsrTestEmailLastResponse = null;
    $('#dsr-test-email-btn').on('click', function(e){
        e.preventDefault();
        var btn = $(this);
        btn.prop('disabled', true).text('Sending...');
        var statusSpan = $('#dsr-test-email-status');
        statusSpan.text('');
        $.post(ajaxurl, {action: 'dsr_send_test_email'}, function(response){
            btn.prop('disabled', false).text('Send Test Email');
            dsrTestEmailLastResponse = response;
            if(response.success){
                statusSpan.css('color','#28a745').text('Test email sent successfully!');
            } else {
                var msg = response.data || 'Failed to send test email.';
                statusSpan.css('color','#dc3545').text(msg);
            }
            if(response.data && response.data.debug){
                statusSpan.append('<br><span style="color:#888;font-size:12px;">Debug: ' + JSON.stringify(response.data.debug) + '</span>');
                console.log('[DSR Test Email Debug]', response.data.debug);
            }
        }).fail(function(xhr, status, error){
            dsrTestEmailLastResponse = {xhr: xhr, status: status, error: error};
            var statusSpan = $('#dsr-test-email-status');
            statusSpan.css('color','#dc3545').text('AJAX error: ' + error);
            statusSpan.append('<br><span style="color:#888;font-size:12px;">AJAX failed. See console for details.</span>');
            console.log('[DSR Test Email Debug] AJAX error:', error, xhr);
        });
    });
    $('#dsr-test-email-debug-btn').on('click', function(){
        if (dsrTestEmailLastResponse) {
            alert('Debug info (see console for details)');
            console.log('[DSR Test Email Debug]', dsrTestEmailLastResponse);
        } else {
            alert('No debug info available yet. Please send a test email first.');
        }
    });
    // License check button handler
    $(document).on('click', '#dsr-check-license-btn', function(e) {
        e.preventDefault();
        var btn = $(this);
        var input = $('#license_key');
        var domain = window.location.hostname;
        var email = '';
        btn.prop('disabled', true).text('Checking...');
        // Optionally, you can fetch email from another field if needed
        var statusMsg = $('<span class="dsr-license-status-msg" style="margin-left:12px;font-size:15px;"></span>');
        btn.after(statusMsg);
        $.post(ajaxurl, {
            action: 'dsr_check_for_license',
            domain: domain,
            email: email
        }, function(response) {
            btn.prop('disabled', false).text('Check for License');
            statusMsg.remove();
            if(response.success && response.data.license_key) {
                input.val(response.data.license_key);
                input.css('background', '#e9ffe9');
                $('<span class="dsr-license-status-msg" style="margin-left:12px;font-size:15px;color:#28a745;">License found and filled!</span>').insertAfter(btn);
            } else {
                $('<span class="dsr-license-status-msg" style="margin-left:12px;font-size:15px;color:#dc3545;">No license found for this domain.</span>').insertAfter(btn);
            }
        }).fail(function(xhr, status, error) {
            btn.prop('disabled', false).text('Check for License');
            statusMsg.remove();
            $('<span class="dsr-license-status-msg" style="margin-left:12px;font-size:15px;color:#dc3545;">AJAX error: ' + error + '</span>').insertAfter(btn);
        });
    });
});
