<?php
session_start();

// Settings
$width = 120;
$height = 36;
$length = 5;
$font_size = 18;
$font = __DIR__ . '/arial.ttf'; // You can include a TTF font file in assets or use GD built-in fonts

// Generate random code
$chars = 'ABCDEFGHJKLMNPQRSTUVWXYZ23456789';
$code = '';
for ($i = 0; $i < $length; $i++) {
    $code .= $chars[rand(0, strlen($chars) - 1)];
}
$_SESSION['dsr_captcha'] = $code;

// Create image
$image = imagecreatetruecolor($width, $height);
$bg_color = imagecolorallocate($image, 255, 255, 255);
$text_color = imagecolorallocate($image, 60, 60, 60);
$noise_color = imagecolorallocate($image, 180, 180, 180);

imagefilledrectangle($image, 0, 0, $width, $height, $bg_color);

// Add noise
for ($i = 0; $i < 30; $i++) {
    imageline($image, rand(0, $width), rand(0, $height), rand(0, $width), rand(0, $height), $noise_color);
}
for ($i = 0; $i < 100; $i++) {
    imagesetpixel($image, rand(0, $width), rand(0, $height), $noise_color);
}

// Draw text
if (file_exists($font)) {
    $textbox = imagettfbbox($font_size, 0, $font, $code);
    $x = ($width - ($textbox[2] - $textbox[0])) / 2;
    $y = ($height - ($textbox[5] - $textbox[1])) / 2;
    $y += $font_size;
    imagettftext($image, $font_size, 0, $x, $y, $text_color, $font, $code);
} else {
    // fallback to built-in font
    imagestring($image, 5, 28, 10, $code, $text_color);
}

// Output
header('Content-Type: image/png');
imagepng($image);
imagedestroy($image);
