<?php $captcha_type = get_option('dsr_captcha_type', 'simple'); $recaptcha_site_key = get_option('dsr_recaptcha_site_key', ''); ?>
<div class="dsr-form-modern">
    <div class="dsr-section dsr-section-tracking" style="margin-bottom:32px;">
        <h3><span class="dashicons dashicons-search"></span> <?php _e('Track Your Request', 'dsr-form'); ?></h3>
        <div class="dsr-tracking-box">
            <input type="text" id="dsr-tracking-id-check" inputmode="numeric" pattern="\\d{6}" placeholder="Enter your 6-digit Tracking ID" maxlength="6" aria-label="Tracking ID" autocomplete="off" required>
            <button type="button" id="dsr-check-tracking-btn" class="button dsr-theme-btn">Check Status</button>
        </div>
        <div id="dsr-tracking-status-result" class="dsr-tracking-result" aria-live="polite"></div>
    </div>
    <div class="dsr-section dsr-section-form">
        <h3><span class="dashicons dashicons-edit"></span> <?php _e('Submit a Data Subject Request', 'dsr-form'); ?></h3>
        <form id="dsr-request-form" method="post" enctype="multipart/form-data" autocomplete="on" novalidate>
            <input type="hidden" name="security" value="<?php echo wp_create_nonce('dsr_request_nonce'); ?>">
            <input type="hidden" name="action" value="dsr_submit_request">
            <div class="dsr-form-group">
                <label for="dsr-user-type"><?php _e('Select Region', 'dsr-form'); ?> <span style="color:red">*</span></label>
                <select name="user_type" id="dsr-user-type" required aria-required="true">
                    <option value="eu"><?php _e('EU Users', 'dsr-form'); ?></option>
                    <option value="california"><?php _e('California Users', 'dsr-form'); ?></option>
                    <option value="other"><?php _e('Other Users', 'dsr-form'); ?></option>
                </select>
            </div>
            <div class="dsr-form-group">
                <label><?php _e('I am a (an)', 'dsr-form'); ?> <span style="color:red">*</span></label>
                <div class="dsr-btn-group dsr-single-select" role="radiogroup" aria-required="true">
                    <label><input type="radio" name="user_identity" value="Customer" required style="display:none;" aria-label="Customer"> <span class="dsr-btn">Customer</span></label>
                    <label><input type="radio" name="user_identity" value="Prospect" required style="display:none;" aria-label="Prospect"> <span class="dsr-btn">Prospect</span></label>
                    <label><input type="radio" name="user_identity" value="Visitor" required style="display:none;" aria-label="Visitor"> <span class="dsr-btn">Visitor</span></label>
                </div>
            </div>
            <div class="dsr-form-group">
                <label><?php _e('Select request type(s)', 'dsr-form'); ?> <span style="color:red">*</span></label>
                <div class="dsr-btn-group dsr-multi-select" role="group" aria-required="true">
                    <label><input type="checkbox" name="request_types[]" value="Opt out" style="display:none;" aria-label="Opt out"> <span class="dsr-btn">Opt out</span></label>
                    <label><input type="checkbox" name="request_types[]" value="Update Data" style="display:none;" aria-label="Update Data"> <span class="dsr-btn">Update Data</span></label>
                    <label><input type="checkbox" name="request_types[]" value="Info Request / Data Portability" style="display:none;" aria-label="Info Request / Data Portability"> <span class="dsr-btn">Info Request / Data Portability</span></label>
                    <label><input type="checkbox" name="request_types[]" value="Data Deletion" style="display:none;" aria-label="Data Deletion"> <span class="dsr-btn">Data Deletion</span></label>
                    <label><input type="checkbox" name="request_types[]" value="Object to or Restrict Processing" style="display:none;" aria-label="Object to or Restrict Processing"> <span class="dsr-btn">Object to or Restrict Processing</span></label>
                    <label><input type="checkbox" name="request_types[]" value="File a Complaint" style="display:none;" aria-label="File a Complaint"> <span class="dsr-btn">File a Complaint</span></label>
                </div>
            </div>
            <div class="dsr-form-row" style="display:flex; gap:16px;">
                <div class="dsr-form-group" style="flex:1;">
                    <label for="dsr-first-name"><?php _e('First Name', 'dsr-form'); ?> <span style="color:red">*</span></label>
                    <input type="text" id="dsr-first-name" name="first_name" required autocomplete="given-name" aria-required="true" pattern="[A-Za-z\s'-]+">
                </div>
                <div class="dsr-form-group" style="flex:1;">
                    <label for="dsr-last-name"><?php _e('Last Name', 'dsr-form'); ?> <span style="color:red">*</span></label>
                    <input type="text" id="dsr-last-name" name="last_name" required autocomplete="family-name" aria-required="true" pattern="[A-Za-z\s'-]+">
                </div>
            </div>
            <div class="dsr-form-row" style="display:flex; gap:16px;">
                <div class="dsr-form-group" style="flex:1;">
                    <label for="dsr-email"><?php _e('Email', 'dsr-form'); ?> <span style="color:red">*</span></label>
                    <input type="email" id="dsr-email" name="email" required autocomplete="email" aria-required="true">
                </div>
                <div class="dsr-form-group" style="flex:1;">
                    <label for="dsr-country"><?php _e('Country', 'dsr-form'); ?> <span style="color:red">*</span></label>
                    <select id="dsr-country" name="country" required autocomplete="country" aria-required="true">
                        <option value=""><?php _e('Select a country', 'dsr-form'); ?></option>
                        <option value="United States">United States</option>
                        <option value="United Kingdom">United Kingdom</option>
                        <option value="Afghanistan">Afghanistan</option>
                        <option value="Albania">Albania</option>
                        <option value="Algeria">Algeria</option>
                        <option value="American Samoa">American Samoa</option>
                        <option value="Andorra">Andorra</option>
                        <option value="Angola">Angola</option>
                        <option value="Anguilla">Anguilla</option>
                        <option value="Antarctica">Antarctica</option>
                        <option value="Antigua and Barbuda">Antigua and Barbuda</option>
                        <option value="Argentina">Argentina</option>
                        <option value="Armenia">Armenia</option>
                        <option value="Aruba">Aruba</option>
                        <option value="Australia">Australia</option>
                        <option value="Austria">Austria</option>
                        <option value="Azerbaijan">Azerbaijan</option>
                        <option value="Bahamas">Bahamas</option>
                        <option value="Bahrain">Bahrain</option>
                        <option value="Bangladesh">Bangladesh</option>
                        <option value="Barbados">Barbados</option>
                        <option value="Belarus">Belarus</option>
                        <option value="Belgium">Belgium</option>
                        <option value="Belize">Belize</option>
                        <option value="Benin">Benin</option>
                        <option value="Bermuda">Bermuda</option>
                        <option value="Bhutan">Bhutan</option>
                        <option value="Bolivia">Bolivia</option>
                        <option value="Bosnia and Herzegovina">Bosnia and Herzegovina</option>
                        <option value="Botswana">Botswana</option>
                        <option value="Brazil">Brazil</option>
                        <option value="British Indian Ocean Territory">British Indian Ocean Territory</option>
                        <option value="Brunei">Brunei</option>
                        <option value="Bulgaria">Bulgaria</option>
                        <option value="Burkina Faso">Burkina Faso</option>
                        <option value="Burundi">Burundi</option>
                        <option value="Cambodia">Cambodia</option>
                        <option value="Cameroon">Cameroon</option>
                        <option value="Canada">Canada</option>
                        <option value="Cape Verde">Cape Verde</option>
                        <option value="Cayman Islands">Cayman Islands</option>
                        <option value="Central African Republic">Central African Republic</option>
                        <option value="Chad">Chad</option>
                        <option value="Chile">Chile</option>
                        <option value="China">China</option>
                        <option value="Christmas Island">Christmas Island</option>
                        <option value="Cocos (Keeling) Islands">Cocos (Keeling) Islands</option>
                        <option value="Colombia">Colombia</option>
                        <option value="Comoros">Comoros</option>
                        <option value="Congo">Congo</option>
                        <option value="Cook Islands">Cook Islands</option>
                        <option value="Costa Rica">Costa Rica</option>
                        <option value="Croatia">Croatia</option>
                        <option value="Cuba">Cuba</option>
                        <option value="Cyprus">Cyprus</option>
                        <option value="Czech Republic">Czech Republic</option>
                        <option value="Denmark">Denmark</option>
                        <option value="Djibouti">Djibouti</option>
                        <option value="Dominica">Dominica</option>
                        <option value="Dominican Republic">Dominican Republic</option>
                        <option value="East Timor">East Timor</option>
                        <option value="Ecuador">Ecuador</option>
                        <option value="Egypt">Egypt</option>
                        <option value="El Salvador">El Salvador</option>
                        <option value="Equatorial Guinea">Equatorial Guinea</option>
                        <option value="Eritrea">Eritrea</option>
                        <option value="Estonia">Estonia</option>
                        <option value="Ethiopia">Ethiopia</option>
                        <option value="Falkland Islands">Falkland Islands</option>
                        <option value="Faroe Islands">Faroe Islands</option>
                        <option value="Fiji">Fiji</option>
                        <option value="Finland">Finland</option>
                        <option value="France">France</option>
                        <option value="French Guiana">French Guiana</option>
                        <option value="French Polynesia">French Polynesia</option>
                        <option value="Gabon">Gabon</option>
                        <option value="Gambia">Gambia</option>
                        <option value="Georgia">Georgia</option>
                        <option value="Germany">Germany</option>
                        <option value="Ghana">Ghana</option>
                        <option value="Gibraltar">Gibraltar</option>
                        <option value="Greece">Greece</option>
                        <option value="Greenland">Greenland</option>
                        <option value="Grenada">Grenada</option>
                        <option value="Guadeloupe">Guadeloupe</option>
                        <option value="Guam">Guam</option>
                        <option value="Guatemala">Guatemala</option>
                        <option value="Guinea">Guinea</option>
                        <option value="Guinea-Bissau">Guinea-Bissau</option>
                        <option value="Guyana">Guyana</option>
                        <option value="Haiti">Haiti</option>
                        <option value="Honduras">Honduras</option>
                        <option value="Hong Kong">Hong Kong</option>
                        <option value="Hungary">Hungary</option>
                        <option value="Iceland">Iceland</option>
                        <option value="India">India</option>
                        <option value="Indonesia">Indonesia</option>
                        <option value="Iran">Iran</option>
                        <option value="Iraq">Iraq</option>
                        <option value="Ireland">Ireland</option>
                        <option value="Israel">Israel</option>
                        <option value="Italy">Italy</option>
                        <option value="Jamaica">Jamaica</option>
                        <option value="Japan">Japan</option>
                        <option value="Jordan">Jordan</option>
                        <option value="Kazakhstan">Kazakhstan</option>
                        <option value="Kenya">Kenya</option>
                        <option value="Kiribati">Kiribati</option>
                        <option value="North Korea">North Korea</option>
                        <option value="South Korea">South Korea</option>
                        <option value="Kuwait">Kuwait</option>
                        <option value="Kyrgyzstan">Kyrgyzstan</option>
                        <option value="Laos">Laos</option>
                        <option value="Latvia">Latvia</option>
                        <option value="Lebanon">Lebanon</option>
                        <option value="Lesotho">Lesotho</option>
                        <option value="Liberia">Liberia</option>
                        <option value="Libya">Libya</option>
                        <option value="Liechtenstein">Liechtenstein</option>
                        <option value="Lithuania">Lithuania</option>
                        <option value="Luxembourg">Luxembourg</option>
                        <option value="Macau">Macau</option>
                        <option value="North Macedonia">North Macedonia</option>
                        <option value="Madagascar">Madagascar</option>
                        <option value="Malawi">Malawi</option>
                        <option value="Malaysia">Malaysia</option>
                        <option value="Maldives">Maldives</option>
                        <option value="Mali">Mali</option>
                        <option value="Malta">Malta</option>
                        <option value="Marshall Islands">Marshall Islands</option>
                        <option value="Martinique">Martinique</option>
                        <option value="Mauritania">Mauritania</option>
                        <option value="Mauritius">Mauritius</option>
                        <option value="Mayotte">Mayotte</option>
                        <option value="Mexico">Mexico</option>
                        <option value="Micronesia">Micronesia</option>
                        <option value="Moldova">Moldova</option>
                        <option value="Monaco">Monaco</option>
                        <option value="Mongolia">Mongolia</option>
                        <option value="Montenegro">Montenegro</option>
                        <option value="Montserrat">Montserrat</option>
                        <option value="Morocco">Morocco</option>
                        <option value="Mozambique">Mozambique</option>
                        <option value="Myanmar">Myanmar</option>
                        <option value="Namibia">Namibia</option>
                        <option value="Nauru">Nauru</option>
                        <option value="Nepal">Nepal</option>
                        <option value="Netherlands">Netherlands</option>
                        <option value="New Caledonia">New Caledonia</option>
                        <option value="New Zealand">New Zealand</option>
                        <option value="Nicaragua">Nicaragua</option>
                        <option value="Niger">Niger</option>
                        <option value="Nigeria">Nigeria</option>
                        <option value="Niue">Niue</option>
                        <option value="Norfolk Island">Norfolk Island</option>
                        <option value="Northern Mariana Islands">Northern Mariana Islands</option>
                        <option value="Norway">Norway</option>
                        <option value="Oman">Oman</option>
                        <option value="Pakistan">Pakistan</option>
                        <option value="Palau">Palau</option>
                        <option value="Palestine">Palestine</option>
                        <option value="Panama">Panama</option>
                        <option value="Papua New Guinea">Papua New Guinea</option>
                        <option value="Paraguay">Paraguay</option>
                        <option value="Peru">Peru</option>
                        <option value="Philippines">Philippines</option>
                        <option value="Pitcairn">Pitcairn</option>
                        <option value="Poland">Poland</option>
                        <option value="Portugal">Portugal</option>
                        <option value="Puerto Rico">Puerto Rico</option>
                        <option value="Qatar">Qatar</option>
                        <option value="Reunion">Reunion</option>
                        <option value="Romania">Romania</option>
                        <option value="Russian Federation">Russian Federation</option>
                        <option value="Rwanda">Rwanda</option>
                        <option value="Saint Kitts and Nevis">Saint Kitts and Nevis</option>
                        <option value="Saint Lucia">Saint Lucia</option>
                        <option value="Saint Vincent and the Grenadines">Saint Vincent and the Grenadines</option>
                        <option value="Samoa">Samoa</option>
                        <option value="San Marino">San Marino</option>
                        <option value="Sao Tome and Principe">Sao Tome and Principe</option>
                        <option value="Saudi Arabia">Saudi Arabia</option>
                        <option value="Senegal">Senegal</option>
                        <option value="Serbia">Serbia</option>
                        <option value="Seychelles">Seychelles</option>
                        <option value="Sierra Leone">Sierra Leone</option>
                        <option value="Singapore">Singapore</option>
                        <option value="Slovakia">Slovakia</option>
                        <option value="Slovenia">Slovenia</option>
                        <option value="Solomon Islands">Solomon Islands</option>
                        <option value="Somalia">Somalia</option>
                        <option value="South Africa">South Africa</option>
                        <option value="Spain">Spain</option>
                        <option value="Sri Lanka">Sri Lanka</option>
                        <option value="Sudan">Sudan</option>
                        <option value="Suriname">Suriname</option>
                        <option value="Svalbard and Jan Mayen">Svalbard and Jan Mayen</option>
                        <option value="Swaziland">Swaziland</option>
                        <option value="Sweden">Sweden</option>
                        <option value="Switzerland">Switzerland</option>
                        <option value="Syria">Syria</option>
                        <option value="Taiwan">Taiwan</option>
                        <option value="Tajikistan">Tajikistan</option>
                        <option value="Tanzania">Tanzania</option>
                        <option value="Thailand">Thailand</option>
                        <option value="Togo">Togo</option>
                        <option value="Tokelau">Tokelau</option>
                        <option value="Tonga">Tonga</option>
                        <option value="Trinidad and Tobago">Trinidad and Tobago</option>
                        <option value="Tunisia">Tunisia</option>
                        <option value="Turkey">Turkey</option>
                        <option value="Turkmenistan">Turkmenistan</option>
                        <option value="Turks and Caicos Islands">Turks and Caicos Islands</option>
                        <option value="Tuvalu">Tuvalu</option>
                        <option value="Uganda">Uganda</option>
                        <option value="Ukraine">Ukraine</option>
                        <option value="United Arab Emirates">United Arab Emirates</option>
                        <option value="Uruguay">Uruguay</option>
                        <option value="Uzbekistan">Uzbekistan</option>
                        <option value="Vanuatu">Vanuatu</option>
                        <option value="Vatican City State">Vatican City State</option>
                        <option value="Venezuela">Venezuela</option>
                        <option value="Vietnam">Vietnam</option>
                        <option value="Virgin Islands (British)">Virgin Islands (British)</option>
                        <option value="Virgin Islands (U.S.)">Virgin Islands (U.S.)</option>
                        <option value="Wallis and Futuna Islands">Wallis and Futuna Islands</option>
                        <option value="Western Sahara">Western Sahara</option>
                        <option value="Yemen">Yemen</option>
                        <option value="Zambia">Zambia</option>
                        <option value="Zimbabwe">Zimbabwe</option>
                    </select>
                </div>
            </div>
            <div class="dsr-form-group">
                <label for="dsr-details"><?php _e('Request Details', 'dsr-form'); ?> <span style="color:red">*</span></label>
                <textarea id="dsr-details" name="details" rows="3" required placeholder="<?php _e('Please provide details for your request...', 'dsr-form'); ?>" aria-required="true"></textarea>
            </div>
            <div class="dsr-form-group dsr-captcha-group">
                <label for="dsr-captcha-field"><?php _e('Captcha', 'dsr-form'); ?></label>
                <?php if ($captcha_type === 'recaptcha' && !empty($recaptcha_site_key)): ?>
                    <div class="g-recaptcha" data-sitekey="<?php echo esc_attr($recaptcha_site_key); ?>"></div>
                <?php else: ?>
                    <input type="text" id="dsr-captcha" name="captcha" required placeholder="<?php _e('Enter the code shown', 'dsr-form'); ?>" aria-required="true" aria-label="Captcha">
                    <img src="<?php echo esc_url(DSR_PLUGIN_URL . 'assets/captcha.php'); ?>" alt="Captcha" style="vertical-align:middle; margin-left:10px;cursor:pointer;" onclick="this.src='<?php echo esc_url(DSR_PLUGIN_URL . 'assets/captcha.php'); ?>?'+Math.random();" title="Click to refresh">
                <?php endif; ?>
            </div>
            <button type="submit" class="dsr-submit-button dsr-theme-btn"><?php _e('Submit Request', 'dsr-form'); ?></button>
            <div id="dsr-response-message" class="dsr-response-message" aria-live="polite"></div>
        </form>
    </div>
</div>
<?php if ($captcha_type === 'recaptcha' && !empty($recaptcha_site_key)): ?>
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
<?php endif; ?>
<style>
.dsr-form-modern {
    font-family: Arial, sans-serif;
    background: #f9f9f9;
    padding: 20px;
    border-radius: 8px;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
}
.dsr-section {
    margin-bottom: 24px;
    padding: 16px;
    background: #fff;
    border-radius: 8px;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
}
.dsr-section h3 {
    margin-top: 0;
    margin-bottom: 16px;
    font-size: 18px;
    color: #333;
}
.dsr-tracking-box {
    display: flex;
    gap: 8px;
    align-items: center;
}
.dsr-tracking-box input {
    flex: 1;
    padding: 10px;
    font-size: 15px;
    border: 1px solid #ccc;
    border-radius: 4px;
}
.dsr-tracking-result {
    margin-top: 10px;
    font-size: 15px;
    color: #333;
}
.dsr-form-group {
    margin-bottom: 16px;
}
.dsr-form-group label {
    margin-bottom: 8px;
    font-weight: 500;
    display: block;
}
.dsr-form-group input,
.dsr-form-group select,
.dsr-form-group textarea {
    width: 100%;
    padding: 10px;
    font-size: 15px;
    border: 1px solid #ccc;
    border-radius: 4px;
    background: #fff;
}
.dsr-btn-group {
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
}
.dsr-btn {
    display: inline-block;
    padding: 10px 20px;
    border: 1px solid #0073aa;
    border-radius: 4px;
    background: #0073aa;
    color: #fff;
    cursor: pointer;
    transition: background 0.2s, border 0.2s;
    user-select: none;
}
.dsr-btn.selected, .dsr-btn:active {
    background: #005177;
    border-color: #005177;
}
.dsr-captcha-group img {
    height: 36px;
    border-radius: 4px;
    border: 1px solid #ccc;
}
.dsr-gdpr-group span {
    font-size: 13px;
}
.dsr-submit-button {
    all: unset;
    display: inline-block;
    font-size: 16px;
    cursor: pointer;
    padding: 10px 24px;
    background: #0073aa;
    color: #fff;
    border-radius: 4px;
    transition: background 0.2s, transform 0.2s;
}
.dsr-submit-button:hover {
    background: #005177;
}
@media (max-width: 600px) {
  .dsr-form-row {
    flex-direction: column;
    gap: 0;
  }
}
</style>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Single select (radio as button)
    document.querySelectorAll('.dsr-single-select input[type="radio"]').forEach(function(radio) {
        radio.addEventListener('change', function() {
            document.querySelectorAll('.dsr-single-select .dsr-btn').forEach(function(btn) {
                btn.classList.remove('selected');
            });
            if (radio.checked) {
                radio.nextElementSibling.classList.add('selected');
            }
        });
    });
    // Multi select (checkbox as button)
    document.querySelectorAll('.dsr-multi-select input[type="checkbox"]').forEach(function(checkbox) {
        checkbox.addEventListener('change', function() {
            if (checkbox.checked) {
                checkbox.nextElementSibling.classList.add('selected');
            } else {
                checkbox.nextElementSibling.classList.remove('selected');
            }
        });
    });
});
</script>