<div class="wrap">
    <h1><?php _e('DSR Request List', 'dsr-form'); ?></h1>
    <button id="dsr-export-csv" class="button button-primary" style="margin-bottom:16px;">Export as CSV</button>
    <p><?php _e('Below is a list of all data subject requests submitted through the form.', 'dsr-form'); ?></p>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        document.getElementById('dsr-export-csv').addEventListener('click', function() {
            const table = document.querySelector('.widefat');
            let csv = '';
            // Get headers
            const headers = Array.from(table.querySelectorAll('thead th')).map(th => '"' + th.innerText.replace(/"/g, '""') + '"');
            csv += headers.join(',') + '\n';
            // Get rows
            table.querySelectorAll('tbody tr').forEach(row => {
                const cells = Array.from(row.querySelectorAll('td')).map(td => '"' + td.innerText.replace(/"/g, '""') + '"');
                csv += cells.join(',') + '\n';
            });
            // Download
            const blob = new Blob([csv], { type: 'text/csv' });
            const url = URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = 'dsr-requests.csv';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.revokeObjectURL(url);
        });
    });
    </script>
    <?php
    global $wpdb;
    $table_name = $wpdb->prefix . 'dsr_requests';
    $requests = $wpdb->get_results("SELECT * FROM $table_name ORDER BY created_at DESC", ARRAY_A);
    if ($requests): ?>
        <table class="widefat fixed" cellspacing="0">
            <thead>
                <tr>
                    <th><?php _e('Tracking ID', 'dsr-form'); ?></th>
                    <th><?php _e('Name', 'dsr-form'); ?></th>
                    <th><?php _e('Email', 'dsr-form'); ?></th>
                    <th><?php _e('Region', 'dsr-form'); ?></th>
                    <th><?php _e('I am a (an)', 'dsr-form'); ?></th>
                    <th><?php _e('Request Type(s)', 'dsr-form'); ?></th>
                    <th><?php _e('IP Address', 'dsr-form'); ?></th>
                    <th><?php _e('Status', 'dsr-form'); ?></th>
                    <th><?php _e('Date & Time Submitted', 'dsr-form'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($requests as $request):
                    $data = maybe_unserialize($request['request_data']); ?>
                    <tr>
                        <td><?php echo esc_html($request['tracking_id']); ?></td>
                        <td><?php echo esc_html(trim(($data['first_name'] ?? '') . ' ' . ($data['last_name'] ?? ''))); ?></td>
                        <td><?php echo esc_html($data['email'] ?? ''); ?></td>
                        <td><?php echo esc_html($data['user_type'] ?? ''); ?></td>
                        <td><?php echo esc_html($data['user_identity'] ?? '-'); ?></td>
                        <td>
                            <?php
                            if (!empty($data['request_types'])) {
                                echo esc_html(is_array($data['request_types']) ? implode(', ', $data['request_types']) : $data['request_types']);
                            } elseif (!empty($data['request_type'])) {
                                echo esc_html($data['request_type']);
                            } else {
                                echo '-';
                            }
                            ?>
                        </td>
                        <td><?php echo esc_html($data['ip_address'] ?? '-'); ?></td>
                        <td><?php echo esc_html($request['status'] === 'pending' ? __('Filed', 'dsr-form') : ucwords($request['status'])); ?></td>
                        <td><?php echo esc_html(date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime($request['created_at']))); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <p><?php _e('No requests found.', 'dsr-form'); ?></p>
    <?php endif; ?>
</div>
