<?php
class DSR_DB_Handler {
    private static $table_name = 'dsr_requests';
    
    public function __construct() {
        error_log('DSR_DB_Handler instantiated');
        add_action('plugins_loaded', array($this, 'init'));
    }
    
    public function init() {
        error_log('DSR_DB_Handler init method called');
        // Placeholder for future initialization logic
        // Currently, this method does nothing
    }
    
    public static function create_tables() {
        global $wpdb;
        $charset_collate = $wpdb->get_charset_collate();
        $table_name = $wpdb->prefix . self::$table_name;
        
        $sql = "CREATE TABLE $table_name (
            request_id bigint(20) NOT NULL AUTO_INCREMENT,
            tracking_id varchar(32) NOT NULL,
            user_type varchar(20) NOT NULL,
            request_data longtext NOT NULL,
            status varchar(20) DEFAULT 'pending',
            created_at datetime NOT NULL,
            updated_at datetime NOT NULL,
            PRIMARY KEY  (request_id),
            UNIQUE KEY tracking_id (tracking_id)
        ) $charset_collate;";
        
        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }
    
    public function save_request($data) {
        global $wpdb;
        $table_name = $wpdb->prefix . self::$table_name;
        
        $current_time = current_time('mysql');
        
        // Generate a random 6-digit tracking ID and ensure uniqueness
        do {
            $tracking_id = strval(rand(100000, 999999));
            $exists = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_name WHERE tracking_id = %s", $tracking_id));
        } while ($exists > 0);
        $wpdb->insert($table_name, array(
            'tracking_id' => $tracking_id,
            'user_type' => sanitize_text_field($data['user_type']),
            'request_data' => maybe_serialize($data),
            'status' => 'pending',
            'created_at' => $current_time,
            'updated_at' => $current_time
        ));
        return $tracking_id;
    }
    
    public function get_request($tracking_id) {
        global $wpdb;
        $table_name = $wpdb->prefix . self::$table_name;
        
        $request = $wpdb->get_row(
            $wpdb->prepare("SELECT * FROM $table_name WHERE tracking_id = %s", $tracking_id),
            ARRAY_A
        );
        
        if ($request) {
            $request['request_data'] = maybe_unserialize($request['request_data']);
        }
        
        return $request;
    }
}